<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Helpers\Strings;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_advanced_feature__virtual_category_text", indexes={@ORM\Index(name="eafvct_url_locale", columns={"url", "locale"})})
 * @ORM\Entity
 */
class VirtualCategoryText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="VirtualCategory", inversedBy="texts")
	 * @ORM\JoinColumn(name="id", onDelete="CASCADE", nullable=false)
	 */
	protected VirtualCategory $virtualCategory;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="locale", type="string", length=255, nullable=false)
	 */
	protected string $locale;

	/**
	 * @ORM\Column(name="url", type="string", nullable=false)
	 */
	protected string $url;

	/**
	 * SEO titulek
	 * @ORM\Column(name="page_title", type="string", nullable=true)
	 */
	public ?string $pageTitle = null;

	/**
	 * @ORM\Column(name="filtering_title", type="string", nullable=true)
	 */
	public ?string $filteringTitle = null;

	/**
	 * SEO description
	 * @ORM\Column(name="page_description", type="text", nullable=true)
	 */
	public ?string $pageDescription = null;

	/**
	 * Nadpis H1
	 * @ORM\Column(name="h1", type="string", nullable=true)
	 */
	public ?string $h1 = null;

	/**
	 * @ORM\Column(name="menu_title", type="string", length=255, nullable=true)
	 */
	public ?string $menuTitle = null;

	/**
	 * Kategorie kraty popis
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public ?string $description = null;

	/**
	 * Kategorie dlouhy popis
	 * @ORM\Column(name="long_description", type="text", nullable=true)
	 */
	public ?string $longDescription = null;

	public function __construct(
		VirtualCategory $virtualCategory,
		string          $locale,
		string          $url
	)
	{
		$this->virtualCategory = $virtualCategory;
		$this->locale          = $locale;
		$this->setUrl($url);
	}

	public function getVirtualCategory(): VirtualCategory { return $this->virtualCategory; }

	public function setUrl(string $url): void
	{
		if (!Strings::startsWith($url, '/')) {
			$url = '/' . $url;
		}

		$this->url = Strings::webalize($url, '/');
	}

	public function getUrl(): string { return $this->url; }
}
