<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Helpers;

class VirtualCategoryHelper
{
	protected static array $createPrepare = [];

	public static function prepareCreateVirtualCategory(string $url, array $categories, array $featureValues, array $manufacturers): void
	{
		self::$createPrepare[$url] = [
			'categories'    => $categories,
			'featureValues' => $featureValues,
			'manufacturers' => $manufacturers,
		];
	}

	public static function getPreparedVirtualCategories(): array { return self::$createPrepare; }
}
