<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Subscribers;

use Contributte\Events\Extra\Event\Application\ShutdownEvent;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Sites;
use EshopAdvancedFeature\Model\Helpers\VirtualCategoryHelper;
use EshopAdvancedFeature\Model\Publishers\VirtualCategoryPublisher;
use EshopAdvancedFeature\Model\VirtualCategories as DefaultVirtualCategories;
use Nette\Localization\Translator;
use Nette\DI\Container;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;
use Tracy\Logger;

class ApplicationSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator   $em;
	protected Translator               $translator;
	protected DefaultVirtualCategories $virtualCategories;
	protected Sites                    $sites;
	protected Container                $container;

	public function __construct(
		EntityManagerDecorator   $em,
		Translator               $translator,
		DefaultVirtualCategories $virtualCategories,
		Sites                    $sites,
		Container                $container
	)
	{
		$this->em                = $em;
		$this->translator        = $translator;
		$this->virtualCategories = $virtualCategories;
		$this->sites             = $sites;
		$this->container         = $container;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ShutdownEvent::class => 'shutdown',
		];
	}

	public function shutdown(ShutdownEvent $event): void
	{
		/** @var VirtualCategoryPublisher $virtualCategoryPublisher */
		$virtualCategoryPublisher = $this->container->hasService('virtualCategoryPublisher')
			? $this->container->getService('virtualCategoryPublisher')
			: null;

		if ($virtualCategoryPublisher) {
			try {
				$this->updateByRabbit($virtualCategoryPublisher);
			} catch (\Exception $e) {
				Debugger::log($e, Logger::EXCEPTION);
				$this->updateByDefault();
			}
		} else {
			$this->updateByDefault();
		}
	}

	protected function updateByRabbit(VirtualCategoryPublisher $virtualCategoryPublisher): void
	{
		if (!empty(VirtualCategoryHelper::getPreparedVirtualCategories())) {
			$virtualCategoryPublisher->checkForNew(VirtualCategoryHelper::getPreparedVirtualCategories());
		}
	}

	protected function updateByDefault(): void
	{
		if (!empty(VirtualCategoryHelper::getPreparedVirtualCategories())) {
			$this->virtualCategories->checkForNew(VirtualCategoryHelper::getPreparedVirtualCategories());
		}
	}
}
