<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Components\VirtualCategory;

use Core\Model\Event\Event;
use EshopAdvancedFeature\AdminModule\Model\VirtualCategories;
use EshopAdvancedFeature\Model\Entities\VirtualCategoryRelated;
use EshopCatalog\AdminModule\Components\Categories\RelatedForm as RelatedFormCategories;
use Nette\DI\Attributes\Inject;
use Override;

class RelatedForm extends RelatedFormCategories
{
	#[Inject]
	public VirtualCategories $virtualCategories;

	/********************
	 * ==== HANDLE
	 */

	#[Override]
	public function handleAdd(): void
	{
		$target = (int) $this->getPost('target');
		$key    = (string) $this->getPost('key');

		$result = $this->virtualCategories->addRelated($this->categoryId, $target, $key);
		if ($result instanceof VirtualCategoryRelated) {
			$this->presenter->flashMessageSuccess('default.saved');
		} else {
			$this->presenter->flashMessageDanger('default.error');
		}

		$this->presenter->payload->result = $result instanceof VirtualCategoryRelated ? 'ok' : 'error';
		$this->presenter->payload->id     = $result->getId();
		$this->presenter->payload->key    = $this->t('eshopCatalog.relatedForm.targetKeys.' . $result->targetKey);
		$this->presenter->redrawControl('flashes');
	}

	#[Override]
	public function handleRemove(): void
	{
		$id = (int) $this->getPost('id');

		$result = $this->virtualCategories->removeRelated($id);
		if ($result) {
			$this->presenter->flashMessageSuccess('default.removed');
		} else {
			$this->presenter->flashMessageDanger('default.removeFailed');
		}

		$this->presenter->payload->result = $result ? 'ok' : 'error';

		$this->presenter->redrawControl('flashes');
	}

	#[Override]
	public function handleChangePosition(): void
	{
		$presenter = $this->presenter;
		$request   = $presenter->getHttpRequest();

		$id       = (int) $request->getPost('id');
		$position = (int) $request->getPost('position');

		if ($id !== 0) {
			if ($this->virtualCategories->setPosition($id, $position)) {
				$presenter->flashMessageSuccess('default.positionChanged');
			} else {
				$presenter->flashMessageDanger('default.positionChangeFailed');
			}
		}

		$presenter->redrawControl('flashes');
	}

	#[Override]
	public function getRelated(): array
	{
		/** @var array<int|string, array> $preloaded */
		$preloaded = [];
		$arr       = [];
		$roots     = array_flip($this->frontCategories->getAllRootIds());
		$rootsById = $this->frontCategories->getRootsForIds();
		$related   = $this->virtualCategories->getByFeatureNavigation($this->categoryId);

		$event = new Event([
			'related' => $related,
			'arr'     => &$preloaded,
		]);
		$this->eventDispatcher->dispatch($event, RelatedFormCategories::class . '::getRelated');

		foreach ($related as $id => $row) {
			if (isset($preloaded[$id])) {
				$arr[$id] = $preloaded[$id];
			} else {
				$name = '';
				if ($row['targetKey'] === 'category') {
					$cat  = $this->frontCategories->getCategories($rootsById[$row['targetId']])[$row['targetId']];
					$name = $roots[$cat->getRootId()] . ' > ' . ($cat->getParent() ? $cat->getParentPathStringFlipped() . ' > ' : '') . $cat->name;
				}

				$arr[$id] = $row + [
						'name' => $name,
					];
			}
		}

		return $arr;
	}
}
