<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\Event\SetFormDataEvent;
use Core\Model\UI\Form\BootstrapRenderer;
use EshopCatalog\AdminModule\Components\Categories\CategoryForm;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\Category;
use Nette\Forms\Controls\SelectBox;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryFormSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $entityManager,
		protected CacheService           $cacheService,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			CategoryForm::class . '::createForm'  => ['createForm', 100],
			CategoryForm::class . '::formSuccess' => ['formSuccess', 100],
			CategoryForm::class . '::setCategory' => ['setCategory', 100],
		];
	}

	public function createForm(CreateFormEvent $event): void
	{
		$form = $event->form;

		$form->addSelect('rod', 'eshopAdvancedFeature.feature.rod', [
			''  => '',
			'm' => 'eshopAdvancedFeature.feature.rodList.m',
			'z' => 'eshopAdvancedFeature.feature.rodList.z',
			's' => 'eshopAdvancedFeature.feature.rodList.s',
		]);

		/** @var BootstrapRenderer $renderer */
		$renderer = $form->getRenderer();
		$renderer->addToBaseExtendedLayout('left', 'rod');
	}

	public function formSuccess(FormSuccessEvent $event): void
	{
		/** @var Category $category */
		$category = $event->custom['entity'];

		$category->rod = $event->values->rod ?: null;

		$this->entityManager->persist($category);
		$this->entityManager->flush();
	}

	public function setCategory(SetFormDataEvent $event): void
	{
		/** @var Category|null $category */
		$category = $event->entity;

		if ($category) {
			/** @var SelectBox $c */
			$c = $event->form->getComponent('rod');

			if ($category->rod && array_key_exists($category->rod, $c->getItems())) {
				$c->setDefaultValue($category->rod);
			}
		}
	}
}
