<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Doctrine;
use EshopAdvancedFeature\Model\Utils\InvalidUrlChecker;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshop-advanced-features:check-invalid-url')]
class CheckInvalidUrl extends Command
{
	public function __construct(
		protected InvalidUrlChecker $invalidUrlChecker,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshop-advanced-features:check-invalid-url');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Eshop advanced features - check invalid url');

		try {
			$this->invalidUrlChecker->checkInvalidUrl();
			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
