<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\FrontModule\Presenters;

use EshopAdvancedFeature\FrontModule\Model\Dao\Group;
use EshopAdvancedFeature\FrontModule\Model\Groups;
use EshopAdvancedFeature\Model\VirtualCategories;
use Pages\FrontModule\Model\Dao\DaoTemplatePage;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Paths;

class DefaultPresenter extends BasePresenter
{
	public ?Group $group = null;

	protected ?DaoTemplatePage $templatePage = null;

	public function __construct(
		protected VirtualCategories $virtualCategories,
		protected Paths             $pathsService,
		protected TemplatePages     $templatePagesService,
		protected Groups            $groups
	)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionVirtualCategoryGroup(int $id): void
	{
		$this->templatePage = $templatePage = $this->templatePagesService->get((int) $this->getActiveNavigation()->componentParams['templatePage']);

		$this->group = $this->groups->getGroup($id);
		$this->template->setFile($this->pathsService->getTemplatePagesFile($templatePage->getTemplate()));
	}

	/*******************************************************************************************************************
	 * ============================== Render
	 */

	public function renderVirtualCategoryGroup(): void
	{
		$nav = $this->getActiveNavigation();

		$this['eshopNavigation']->currentCategoryId = 'virtualCategory_' . $nav->componentParams['group'];

		$templatePage = $this->templatePage;

		$this->template->templateTextValues = $templatePage->getTexts();
		$this->template->pageClass          .= ' page-eshopcatalog-category page-eshopcatalog-category--virtual';

		$this->template->virtualCategoryGroup = $this->group;
		$this->template->showSubcategories    = true;
		$this->template->categoryName         = $nav->title;
		$this->template->description          = $nav->description;
		$this->template->shortDescription     = $this->group->description ?? null;
		$this->template->pageTitle            = $nav->title;
	}

}
