<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Consumers;

use Bunny\Message;
use Contributte\RabbitMQ\Consumer\IConsumer;
use Core\Model\Entities\EntityManagerDecorator;
use EshopAdvancedFeature\Model\VirtualCategories;
use Nette\Utils\Json;
use Override;

class VirtualCategoryConsumer implements IConsumer
{
	public function __construct(
		protected VirtualCategories      $virtualCategories,
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public function consume(Message $message): int
	{
		$data = Json::decode($message->content, forceArrays: true);

		if ($data['data'] && $data['siteIdent'] && $data['locale']) {
			$this->virtualCategories->checkForNew($data['data'], $data['siteIdent'], $data['locale']);
		}

		gc_collect_cycles();
		$this->em->clear();

		return IConsumer::MESSAGE_ACK;
	}
}
