<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Feature;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'eshop_advanced_feature__virtual_category_group_filter')]
#[ORM\Entity]
class VirtualCategoryGroupFilter
{
	/** @Gedmo\SortableGroup */
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: VirtualCategoryGroup::class, inversedBy: 'filters')]
	public VirtualCategoryGroup $group;

	#[ORM\JoinColumn(name: 'feature_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Feature::class)]
	public Feature $feature;

	/** @Gedmo\SortablePosition */
	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true, 'default' => 0])]
	public int $position = 0;

	public function __construct(
		VirtualCategoryGroup $group,
		Feature              $feature
	)
	{
		$this->group   = $group;
		$this->feature = $feature;
	}
}
