<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\Repository\SortableRepository;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'eshop_advanced_feature__virtual_category_in_group')]
#[ORM\Entity(repositoryClass: SortableRepository::class)]
class VirtualCategoryInGroup
{
	use TId;

	/** @Gedmo\SortableGroup */
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: VirtualCategoryGroup::class, inversedBy: 'virtualCategoriesInGroup')]
	public VirtualCategoryGroup $group;

	#[ORM\JoinColumn(name: 'virtual_category_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: VirtualCategory::class, inversedBy: 'inGroups')]
	public VirtualCategory $virtualCategory;

	/** @Gedmo\SortablePosition */
	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true, 'default' => 0])]
	public int $position;

	public function __construct(
		VirtualCategoryGroup $virtualCategoryGroup,
		VirtualCategory      $virtualCategory
	)
	{
		$this->group           = $virtualCategoryGroup;
		$this->virtualCategory = $virtualCategory;
		$this->position        = 0;
	}
}
