<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\EntityRemoveEvent;
use EshopCatalog\Model\Entities\Category;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategorySubscriber implements EventSubscriberInterface
{
	protected array $forRemove = [];

	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			Category::class . '::preRemove' => ['categoryPreRemove'],
			Category::class . '::remove'    => ['categoryRemove'],
		];
	}

	public function categoryPreRemove(EntityRemoveEvent $event): void
	{
		if ($event->entityId === '' || $event->entityId === '0') {
			return;
		}

		$this->forRemove[$event->entityId] = [];
		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT virtual_category_id FROM eshop_advanced_feature__virtual_category_categories WHERE category_id = :id", [
			':id' => $event->entityId,
		]) as $row) {
			$this->forRemove[$event->entityId][] = $row['virtual_category_id'];
		}
	}

	public function categoryRemove(EntityRemoveEvent $event): void
	{
		if ($event->entityId === '' || $event->entityId === '0') {
			return;
		}

		foreach ($this->forRemove[$event->entityId] ?? [] as $v) {
			$this->em->getConnection()->executeQuery("DELETE FROM eshop_advanced_feature__virtual_category WHERE id = :id", [
				':id' => $v,
			]);
		}
	}
}
