<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class VirtualCategoriesCache
{
	public const cacheNamespace = 'eshopAdvancedFeature';

	protected Cache $cache;

	public function __construct(Storage $storage)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	public function getCache(): Cache { return $this->cache; }

	public function clearRelated(): void
	{
		$this->getCache()->remove('related');
	}
}
