<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Components\VirtualCategory;

use Core\AdminModule\Model\Sites;
use Core\Model\Http\Session;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopAdvancedFeature\AdminModule\Model\VirtualCategoryGroups;
use EshopCatalog\AdminModule\Model\Categories;
use EshopCatalog\AdminModule\Model\Features;
use EshopCatalog\AdminModule\Model\FeatureValues;
use EshopCatalog\AdminModule\Model\Manufacturers;
use Nette\Utils\ArrayHash;

class VirtualCategoryFilterForm extends BaseControl
{
	public string $siteIdent;
	public array  $filter = [];

	protected Features              $features;
	protected FeatureValues         $featureValues;
	protected Manufacturers         $manufacturers;
	protected Categories            $categories;
	protected Sites                 $sites;
	protected VirtualCategoryGroups $groupService;
	protected Session               $session;

	public function __construct(
		string                $siteIdent,
		Sites                 $sites,
		Features              $features,
		FeatureValues         $featureValues,
		Manufacturers         $manufacturers,
		Categories            $categories,
		VirtualCategoryGroups $groupService,
		Session               $session
	)
	{
		$this->siteIdent     = $siteIdent;
		$this->features      = $features;
		$this->featureValues = $featureValues;
		$this->manufacturers = $manufacturers;
		$this->categories    = $categories;
		$this->sites         = $sites;
		$this->groupService  = $groupService;
		$this->session       = $session;

		$this->filter = $this->session->getSection('virtualCategoryFilterForm')->get('values/' . $this->siteIdent) ?? [];
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->setShowLangSwitcher(false);

		$titlePrefix = 'eshopAdvancedFeature.virtualCategory.';

		$form->addSubmit('save', 'default.update');

		$form->addText('urlExact', $titlePrefix . 'urlExact');
		$form->addText('urlContain', $titlePrefix . 'urlContain');

		$form->addCheckboxList('groups', $this->t($titlePrefix . 'groups'), $this->groupService->getOptionsForSelect())
			->setTranslator(null);
		$form->addCheckboxNestedList('categories', $this->t($titlePrefix . 'categories'), $this->categories->getFlatTree($this->siteIdent))
			->setTranslator(null);
		$form->addCheckboxList('manufacturers', $this->t($titlePrefix . 'manufacturers'), $this->manufacturers->getOptionsForSelect())
			->setTranslator(null);

		// Features
		$flat         = [];
		$featureTexts = $this->features->getOptionsForSelect();
		foreach ($this->featureValues->getOptionsForSelect(true) as $featureId => $values) {
			$flat[] = [
				'id'     => 'f' . $featureId,
				'name'   => $featureTexts[$featureId],
				'parent' => 0,
			];

			foreach ($values as $valueId => $value) {
				$flat[] = [
					'id'     => $valueId,
					'name'   => $value,
					'parent' => 'f' . $featureId,
				];
			}
		}
		$form->addCheckboxNestedList('featureValues', $titlePrefix . 'featureValues', $flat);

		$form->addSubmit('save2', 'default.update');

		$form->onSuccess[] = [$this, 'formSuccess'];

		$form->setDefaults($this->filter);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$this->filter = (array) $values;

		$this->session->getSection('virtualCategoryFilterForm')->set('values/' . $this->siteIdent, $this->filter);

		return true;
	}
}
