<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Model\Subscribers;

use Core\Model\Event\Event;
use Doctrine\ORM\Query\Expr\Join;
use EshopAdvancedFeature\Model\VirtualCategories;
use EshopCatalog\AdminModule\Components\Categories\RelatedForm;
use Nette\Application\LinkGenerator;
use Contributte\Translation\Translator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryRelatedFormSubscriber implements EventSubscriberInterface
{
	protected VirtualCategories $virtualCategories;
	protected LinkGenerator     $linkGenerator;
	protected Translator        $translator;

	public function __construct(
		VirtualCategories $virtualCategories,
		LinkGenerator     $linkGenerator,
		Translator        $translator
	)
	{
		$this->virtualCategories = $virtualCategories;
		$this->linkGenerator     = $linkGenerator;
		$this->translator        = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			RelatedForm::class . '::getInputs'  => 'getInputs',
			RelatedForm::class . '::getRelated' => 'getRelated',
		];
	}

	public function getInputs(Event $event): void
	{
		$event->data['inputs']['virtualCategory'] = [
			'title'            => 'eshopAdvancedFeature.related.advancedFeature',
			'targetKey'        => 'virtualCategory',
			'autocompleteName' => 'virtualCategory',
			'url'              => $this->linkGenerator->link("EshopAdvancedFeature:Cron:Default:navigations"),
		];
	}

	public function getRelated(Event $event): void
	{
		$ids = [];
		foreach ($event->data['related'] as $id => $row) {
			if ($row['targetKey'] === 'virtualCategory') {
				$ids[$row['targetId']] = $row;
			}
		}

		foreach ($this->virtualCategories->getEr()->createQueryBuilder('vc')
			         ->select('vc.id, vc.siteIdent, vct.h1, vct.url')
			         ->innerJoin('vc.texts', 'vct', Join::WITH, 'vct.locale = :locale')
			         ->where('vc.id IN (:ids)')
			         ->setParameters([
				         'locale' => $this->translator->getLocale(),
				         'ids'    => array_keys($ids),
			         ])
			         ->getQuery()->getArrayResult() as $row) {
			$relatedRow                            = $ids[$row['id']];
			$event->data['arr'][$relatedRow['id']] = $relatedRow + [
					'name' => $row['siteIdent'] . ' -> ' . $row['h1'] . ' ' . $row['url'],
				];
		}
	}
}
