<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use EshopAdvancedFeature\Model\Entities\VirtualCategoryGroup;

/**
 * @method VirtualCategoryGroup|null getReference($id)
 * @method VirtualCategoryGroup[] getAll()
 * @method VirtualCategoryGroup|null get($id)
 */
class VirtualCategoryGroups extends BaseEntityService
{
	protected $entityClass = VirtualCategoryGroup::class;

	protected Translator $translator;

	protected ?array $cOptionsForSelect = null;

	public function __construct(
		Translator $translator
	)
	{
		$this->translator = $translator;
	}

	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];


			foreach ($this->getEr()->createQueryBuilder('g')->select('g.id, gt.title')
				         ->innerJoin('g.texts', 'gt', Join::WITH, 'gt.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->orderBy('gt.title')->getQuery()->getArrayResult() as $row) {
				$this->cOptionsForSelect[$row['id']] = $row['title'];
			}
		}

		return $this->cOptionsForSelect;
	}
}
