<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Presenters;

use Core\AdminModule\Model\Sites;
use Core\Model\UI\Form\BaseForm;
use EshopAdvancedFeature\AdminModule\Components\Group\GroupsGrid;
use EshopAdvancedFeature\AdminModule\Components\Group\IGroupsGridFactory;
use EshopAdvancedFeature\AdminModule\Components\VirtualCategory\IVirtualCategoriesGridFactory;
use EshopAdvancedFeature\AdminModule\Components\VirtualCategory\IVirtualCategoryFilterFormFactory;
use EshopAdvancedFeature\AdminModule\Components\VirtualCategory\VirtualCategoriesGrid;
use EshopAdvancedFeature\AdminModule\Components\VirtualCategory\VirtualCategoryFilterForm;

class DefaultPresenter extends BasePresenter
{
	protected const ICON = 'far fa-newspaper';

	/** @var string @persistent */
	public string $siteIdent = '';

	protected Sites $sites;

	/**
	 * @param Sites $sites
	 */
	public function __construct(
		Sites $sites
	)
	{
		$this->sites = $sites;
	}

	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopAdvancedFeature.title.virtualCategories', self::ICON);
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionVirtualCategories(?string $siteIdent): void
	{
		if (!$siteIdent) {
			$siteIdent = (string) array_keys($this->sites->getOptionsForSelect(true))[0];
		}

		$this->siteIdent = $siteIdent;

		$this->template->siteIdent = $siteIdent;
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentVirtualCategoriesGrid(IVirtualCategoriesGridFactory $factory): VirtualCategoriesGrid
	{
		$control = $factory->create($this->getParameter('siteIdent'));

		$control->filter = $this['virtualCategoriesFilterForm']->filter;

		return $control;
	}

	protected function createComponentVirtualCategoriesFilterForm(IVirtualCategoryFilterFormFactory $factory): VirtualCategoryFilterForm
	{
		$control = $factory->create($this->getParameter('siteIdent'));

		$control['form']->onSuccess[] = function(BaseForm $form, array $values): void {
			$this['virtualCategoriesGrid']->filter = $values;
			$this['virtualCategoriesGrid']['grid']->redrawControl('grid');
		};

		return $control;
	}

	protected function createComponentVirtualCategoryGroupsGrid(IGroupsGridFactory $factory): GroupsGrid { return $factory->create(); }
}
