<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopAdvancedFeature\Model\VirtualCategories;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class CacheGenerator extends AbstractCommand
{
	/** @var VirtualCategories|null @inject */
	public ?VirtualCategories $virtualCategories;

	/**
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('eshop-advanced-features:cache-generator');
	}

	/**
	 * @return int
	 */
	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Eshop advanced features - prepare cache');

		try {
			$this->virtualCategories->prepareUrlsByRelation();
			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
