<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopAdvancedFeature\Model\Utils\InvalidUrlChecker;
use EshopAdvancedFeature\Model\VirtualCategories;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class CheckInvalidUrl extends AbstractCommand
{
	/** @var InvalidUrlChecker @inject */
	public ?InvalidUrlChecker $invalidUrlChecker;

	/**
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('eshop-advanced-features:check-invalid-url');
	}

	/**
	 * @return int
	 */
	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Eshop advanced features - check invalid url');

		try {
			$this->invalidUrlChecker->checkInvalidUrl();
			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
