<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class CheckUrlInRedirect extends AbstractCommand
{
	/** @var EntityManagerDecorator @inject */
	public ?EntityManagerDecorator $em;

	/**
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('eshop-advanced-features:check-url-in-redirect');
	}

	/**
	 * @return int
	 */
	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Eshop advanced features - check url in redirect');

		try {
			foreach ($this->em->getConnection()->fetchAllAssociative("SELECT id, `from` FROM core__redirect") as $row) {
				$vcExist = $this->em->getConnection()->fetchOne("SELECT id FROM eshop_advanced_feature__virtual_category_text WHERE url = ?", ['/' .$row['from']]);

				if ($vcExist) {
					$this->em->getConnection()->executeQuery("DELETE FROM core__redirect WHERE id = " . $row['id']);
				}
			}

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
