<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class Migrator extends AbstractCommand
{
	/** @var \EshopAdvancedFeature\Model\Migrator|null @inject */
	public ?\EshopAdvancedFeature\Model\Migrator $migrator;

	/** @var EntityManagerDecorator|null @inject */
	public ?EntityManagerDecorator $em;

	/**
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('eshop-advanced-features:migrate');
	}

	/**
	 * @return int
	 */
	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Eshop advanced features - migrate to new version');

		$this->em->beginTransaction();
		try {
			$oldIdToNewIdMap = $this->migrator->migrateNavigation();
			$this->migrator->migrateGroups($oldIdToNewIdMap);
			$this->migrator->migrateMissingLangsInGroups();

			$this->em->commit();
			$output->writeLn('<info>[OK]</info>');
		} catch (\Exception $e) {
			Debugger::$maxLength = 500;
			Debugger::log($e);

			if ($this->em->getConnection()->isTransactionActive()) {
				$this->em->rollback();
			}
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
