<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Consumers;

use Bunny\Message;
use Contributte\RabbitMQ\Consumer\IConsumer;
use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Sites;
use EshopAdvancedFeature\Model\VirtualCategories;
use Nette\Utils\Json;
use Tracy\Debugger;

class VirtualCategoryConsumer implements IConsumer
{
	protected VirtualCategories      $virtualCategories;
	protected EntityManagerDecorator $em;
	protected Translator             $translator;

	public function __construct(
		VirtualCategories      $virtualCategories,
		EntityManagerDecorator $em,
		Translator             $translator
	)
	{
		$this->virtualCategories = $virtualCategories;
		$this->em                = $em;
		$this->translator        = $translator;
	}

	public function consume(Message $message): int
	{
		$data = Json::decode($message->content, Json::FORCE_ARRAY);

		if ($data['data'] && $data['siteIdent'] && $data['locale']) {
			Sites::$currentIdentOverride = $data['siteIdent'];
			Sites::$currentLangOverride  = $data['locale'];
			$this->translator->setLocale($data['locale']);

			$this->virtualCategories->checkForNew($data['data'], $data['siteIdent'], $data['locale']);
		}

		gc_collect_cycles();
		$this->em->clear();

		return IConsumer::MESSAGE_ACK;
	}
}
