<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_advanced_feature__feature_navigation_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class FeatureNavigationGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var Collection<string, FeatureNavigationGroupText>
	 * @ORM\OneToMany(targetEntity="FeatureNavigationGroupText", mappedBy="featureNavigationGroup", indexBy="lang")
	 */
	protected Collection $texts;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $ico = null;

	/**
	 * @var Collection<FeatureNavigationInGroup>
	 * @ORM\OneToMany(targetEntity="FeatureNavigationInGroup", mappedBy="group", cascade={"all"})
	 * @ORM\OrderBy({"position" = "ASC"})
	 */
	public Collection $featureNavigations;

	/**
	 * @var Collection<int, FeatureNavigationGroupFilter>
	 * @ORM\OneToMany(targetEntity="FeatureNavigationGroupFilter", mappedBy="group", indexBy="feature_id")
	 * @ORM\OrderBy({"position" = "ASC"})
	 */
	public $filters;

	public function __construct()
	{
		$this->texts              = new ArrayCollection;
		$this->featureNavigations = new ArrayCollection;
		$this->filters            = new ArrayCollection;
	}

	/**
	 * @return Collection<string, FeatureNavigationGroupText>
	 */
	public function getTexts() { return $this->texts; }

	public function getText(?string $lang = null): ?FeatureNavigationGroupText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/**
	 * @param FeatureNavigationGroupText[] $texts
	 */
	public function setTexts(array $texts): void
	{
		$this->texts = new ArrayCollection($texts);
	}
}
