<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eshop_advanced_feature__feature_navigation_groups")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class FeatureNavigationInGroup
{
	use TId;

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="FeatureNavigationGroup", inversedBy="featureNavigations")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public FeatureNavigationGroup $group;

	/**
	 * @ORM\ManyToOne(targetEntity="FeatureNavigation", inversedBy="groups")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public FeatureNavigation $featureNavigation;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	public int $position;

	public function __construct(FeatureNavigationGroup $group, FeatureNavigation $featureNavigation)
	{
		$this->group             = $group;
		$this->featureNavigation = $featureNavigation;
		$this->position          = -1;
	}

}
