<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_advanced_feature__feature_navigation_related", indexes={@ORM\Index(name="category", columns={"feature_navigation_id"})})
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class FeatureNavigationRelated
{
	use TId;

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="FeatureNavigation", inversedBy="related")
	 * @ORM\JoinColumn(name="feature_navigation_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public FeatureNavigation $featureNavigation;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=false)
	 */
	public int $target;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $targetKey = 'category';

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer", nullable=false)
	 */
	protected int $position = 0;

	public function __construct(FeatureNavigation $featureNavigation, int $target)
	{
		$this->featureNavigation = $featureNavigation;
		$this->target            = $target;
		$this->setPosition(-1);
	}

	public function setPosition(int $pos): void { $this->position = $pos; }
}
