<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_advanced_feature__virtual_category_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class VirtualCategoryGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var Collection<string, VirtualCategoryGroupText>
	 * @ORM\OneToMany(targetEntity="VirtualCategoryGroupText", mappedBy="group", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $icon = null;

	/**
	 * @var Collection<VirtualCategoryInGroup>
	 * @ORM\OneToMany(targetEntity="VirtualCategoryInGroup", mappedBy="group")
	 * @ORM\OrderBy({"position"="ASC"})
	 */
	public Collection $virtualCategoriesInGroup;

	/**
	 * @var Collection<VirtualCategoryGroupFilter>
	 * @ORM\OneToMany(targetEntity="VirtualCategoryGroupFilter", mappedBy="group", indexBy="feature_id")
	 * @ORM\OrderBy({"position"="ASC"})
	 */
	public Collection $filters;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $templatePageGroup = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $templatePageItem = null;

	public function __construct()
	{
		$this->texts                    = new ArrayCollection;
		$this->virtualCategoriesInGroup = new ArrayCollection;
		$this->filters                  = new ArrayCollection;
	}

	public function getText(?string $lang = null): ?VirtualCategoryGroupText { return $this->texts[$lang ?: $this->locale] ?? null; }
}
