<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_advanced_feature__virtual_category_related", indexes={@ORM\Index(name="category", columns={"virtual_category_id"})})
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class VirtualCategoryRelated
{
	use TId;

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="VirtualCategory", inversedBy="related")
	 * @ORM\JoinColumn(name="virtual_category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public VirtualCategory $virtualCategory;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=false)
	 */
	public int $targetId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $targetKey = 'category';

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer", nullable=false)
	 */
	protected int $position = 0;

	public function __construct(
		VirtualCategory $virtualCategory,
		int             $targetId
	)
	{
		$this->virtualCategory = $virtualCategory;
		$this->targetId        = $targetId;
		$this->setPosition(-1);
	}

	public function setPosition(int $pos): void { $this->position = $pos; }
}
