<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Helpers;

use EshopAdvancedFeature\Model\Entities\VirtualCategory;
use Nette\Utils\Json;

class VirtualCategoryHelper
{
	protected static array $createPrepare   = [];
	protected static array $changeLastVisit = [];

	public static function prepareCreateVirtualCategory(
		string $url,
		array  $categories,
		array  $manufacturers,
		array  $featureValues,
		string $siteIdent,
		string $locale
	): void
	{
		$key = $siteIdent . ':' . $locale;
		if (!isset(self::$createPrepare[$key])) {
			self::$createPrepare[$key] = [];
		}

		self::$createPrepare[$key][$url] = [
			VirtualCategory::keyCategories    => $categories,
			VirtualCategory::keyManufacturers => $manufacturers,
			VirtualCategory::keyFeatureValues => $featureValues,
		];
	}

	public static function getPreparedVirtualCategories(): array { return self::$createPrepare; }

	public static function getUrlCacheKey(string $siteIdent, string $locale, array $relations): string
	{
		return 'vc/' . $siteIdent . '/' . $locale . '/' . md5($siteIdent . '/' . Json::encode($relations));
	}

	public static function getChangeLastVisit(): array { return self::$changeLastVisit; }

	public static function updateLastVisit(int $id): void
	{
		self::$changeLastVisit[$id] = [
			'id' => $id,
		];
	}
}
