<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Publishers;

use Contributte\RabbitMQ\Producer\Producer;
use Nette\Utils\Json;

class VirtualCategoryPublisher
{
	protected Producer $producer;

	public function __construct(Producer $producer)
	{
		$this->producer = $producer;
	}

	public function checkForNew(array $data): void
	{
		$json    = Json::encode($data);
		$headers = [];

		$this->producer->publish($json, $headers, 'checkForNew');
	}

}
