<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\EntityRemoveEvent;
use EshopCatalog\Model\Entities\Manufacturer;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ManufacturerSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	protected array $forRemove = [];

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			Manufacturer::class . '::preRemove' => ['manufacturerPreRemove'],
			Manufacturer::class . '::remove'    => ['manufacturerRemove'],
		];
	}

	public function manufacturerPreRemove(EntityRemoveEvent $event): void
	{
		if (!$event->entityId) {
			return;
		}

		$this->forRemove[$event->entityId] = [];
		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT virtual_category_id FROM eshop_advanced_feature__virtual_category_manufacturers WHERE manufacturer_id = :id", [
			':id' => $event->entityId,
		]) as $row) {
			$this->forRemove[$event->entityId][] = $row['virtual_category_id'];
		}
	}

	public function manufacturerRemove(EntityRemoveEvent $event): void
	{
		if (!$event->entityId) {
			return;
		}

		foreach ($this->forRemove[$event->entityId] ?? [] as $v) {
			$this->em->getConnection()->executeQuery("DELETE FROM eshop_advanced_feature__virtual_category WHERE id = :id", [
				':id' => $v,
			]);
		}
	}
}
