<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Utils;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Strings;
use Core\Model\Sites;
use EshopCatalog\FrontModule\Model\Categories as FrontCategories;

class InvalidUrlChecker
{
	protected EntityManagerDecorator $em;
	protected FrontCategories        $frontCategories;
	protected Sites                  $sites;

	public function __construct(
		EntityManagerDecorator $em,
		FrontCategories        $frontCategories,
		Sites                  $sites
	)
	{
		$this->em              = $em;
		$this->frontCategories = $frontCategories;
		$this->sites           = $sites;
	}

	public function checkInvalidUrl(): void
	{
		$this->checkVirtualVsCategoryUrls();
	}

	public function checkVirtualVsCategoryUrls(): void
	{
		foreach ($this->sites->getSites() as $site) {
			foreach ($site->getDomains() as $domain) {
				$rootId = $this->frontCategories->getRootIdForSite($site->getIdent());

				if (!$domain->isActive || !$rootId) {
					continue;
				}

				$catLinks = [];
				foreach ($this->frontCategories->getCategories($rootId, $domain->getLang()) as $category) {
					$catLinks[] = (string) $category->link;
				}

				$toDelete = [];
				foreach ($this->em->getConnection()->fetchAllAssociative("SELECT vct.locale, vct.id, vct.url, vc.id as vcId
					FROM eshop_advanced_feature__virtual_category_text vct
					INNER JOIN eshop_advanced_feature__virtual_category vc ON vc.id = vct.id AND vc.site_ident = :siteIdent AND vc.is_locked = 0
					WHERE vct.locale = :lang", [
					':siteIdent' => $site->getIdent(),
					':lang'      => $domain->getLang(),
				]) as $row) {
					foreach ($catLinks as $link) {
						if (Strings::endsWith($link, (string) $row['url'])) {
							$toDelete[] = $row['vcId'];
						}
					}
				}

				if (!empty($toDelete)) {
					foreach (array_chunk($toDelete, 200) as $chunk) {
						$this->em->getConnection()->executeQuery("DELETE FROM eshop_advanced_feature__virtual_category WHERE id IN (" . implode(',', $chunk) . ")");
					}
				}
			}
		}
	}
}
