<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Doctrine;
use EshopAdvancedFeature\Model\VirtualCategories;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshop-advanced-features:cache-generator')]
class CacheGenerator extends Command
{
	public function __construct(
		protected VirtualCategories $virtualCategories,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshop-advanced-features:cache-generator');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Eshop advanced features - prepare cache');

		try {
			$this->virtualCategories->prepareUrlsByRelation();
			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
