<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Console;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshop-advanced-features:check-url-in-redirect')]
class CheckUrlInRedirect extends Command
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshop-advanced-features:check-url-in-redirect');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Eshop advanced features - check url in redirect');

		try {
			foreach ($this->em->getConnection()->fetchAllAssociative("SELECT id, `from` FROM core__redirect") as $row) {
				$vcExist = $this->em->getConnection()->fetchOne("SELECT id FROM eshop_advanced_feature__virtual_category_text WHERE url = ?", ['/' . $row['from']]);

				if ($vcExist) {
					$this->em->getConnection()->executeQuery("DELETE FROM core__redirect WHERE id = " . $row['id']);
				}
			}

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
