<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\CronModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Sites;
use EshopCatalog\Model\Event\ProductsFeedEvent;
use Navigations\Model\Navigations;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AdsProductsFeedSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Sites                  $sites,
		protected Navigations            $navigations,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopCatalog.categoriesFeed' => ['categoriesFeed', -10],
		];
	}

	public function categoriesFeed(ProductsFeedEvent $event): void
	{
		//		if ($event->customerName !== 'ads')
		//			return;
		//
		//		$currentSite = $this->sites->getCurrentSite();
		//		$baseUrl     = 'https://' . $currentSite->getCurrentDomain()->getDomain() . $this->navigations->getHomepage()->link;
		//
		//		$fp = fopen('php://memory', 'wb+');
		//		foreach ($this->em->getRepository(FeatureNavigationText::class)->createQueryBuilder('nt')
		//			         ->select('nt.url, nt.pageTitle')
		//			         ->innerJoin('nt.featureNavigation', 'n', Join::WITH, 'n.siteIdent = :siteIdent AND n.dynamicParams = :dynParams')
		//			         ->where('nt.locale = :lang')
		//			         ->setParameters([
		//				         'siteIdent' => $currentSite->getIdent(),
		//				         'dynParams' => 0,
		//				         'lang'      => $currentSite->getCurrentDomain()->getLang(),
		//			         ])
		//			         ->getQuery()->getArrayResult() as $row) {
		//			$alias = !empty($row['pageTitle']) ? Strings::webalize($row['pageTitle']) : $row['url'];
		//
		//			fputcsv($fp, [
		//				$baseUrl . $row['url'],
		//				$alias,
		//				$alias,
		//			], ',');
		//		}
		//
		//		rewind($fp);
		//		$event->data['output'] .= stream_get_contents($fp);
		//		fclose($fp);
	}
}
