<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\FrontModule\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Query\Expr\Join;
use EshopAdvancedFeature\FrontModule\Model\Dao\Group;
use EshopAdvancedFeature\Model\Entities\VirtualCategoryGroup;
use EshopAdvancedFeature\Model\GroupsCache;
use Nette\Caching\Cache;

class Groups
{
	public function __construct(
		protected GroupsCache            $groupsCache,
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
	)
	{
	}

	public function getGroup(int $id): ?Group
	{
		return $this->groupsCache->getCache()->load(GroupsCache::getKey($id, $this->translator->getLocale()), function(&$dep) use ($id): ?Group {
			$dep = [
				Cache::EXPIRE => '1 month',
			];

			$data = $this->em->getRepository(VirtualCategoryGroup::class)->createQueryBuilder('g')
				->select('g.id, g.icon, gt.title, gt.description, GROUP_CONCAT(IDENTITY(f.feature)) as filters')
				->leftJoin('g.filters', 'f')
				->innerJoin('g.texts', 'gt', Join::WITH, 'gt.lang = :lang')
				->where('g.id = :id')
				->setParameters(new ArrayCollection([new Parameter('id', $id), new Parameter('lang', $this->translator->getLocale())]))
				->getQuery()->getOneOrNullResult();

			if ($data && $data['id']) {
				$dao              = new Group($data['id']);
				$dao->title       = $data['title'];
				$dao->description = $data['description'];
				$dao->filtersId   = array_map(static fn($v): int => (int) $v, explode(',', (string) $data['filters']));
				$dao->icon        = $data['icon'];

				return $dao;
			}

			return null;
		});
	}
}
