<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20220919075605 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category (id INT AUTO_INCREMENT NOT NULL, is_locked SMALLINT UNSIGNED DEFAULT 0 NOT NULL, icon VARCHAR(255) DEFAULT NULL, site_ident VARCHAR(255) NOT NULL, created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, INDEX eafvc_site (site_ident), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_categories (virtual_category_id INT NOT NULL, category_id INT NOT NULL, INDEX IDX_707AA881C639273 (virtual_category_id), INDEX IDX_707AA8812469DE2 (category_id), PRIMARY KEY(virtual_category_id, category_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_manufacturers (virtual_category_id INT NOT NULL, manufacturer_id INT NOT NULL, INDEX IDX_75AF016A1C639273 (virtual_category_id), INDEX IDX_75AF016AA23B42D (manufacturer_id), PRIMARY KEY(virtual_category_id, manufacturer_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_features (virtual_category_id INT NOT NULL, feature_id INT NOT NULL, INDEX IDX_1F6932AD1C639273 (virtual_category_id), INDEX IDX_1F6932AD60E4B879 (feature_id), PRIMARY KEY(virtual_category_id, feature_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_group (id INT AUTO_INCREMENT NOT NULL, icon VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_group_filter (group_id INT NOT NULL, feature_id INT NOT NULL, position INT UNSIGNED DEFAULT 0 NOT NULL, INDEX IDX_5B80E786FE54D947 (group_id), INDEX IDX_5B80E78660E4B879 (feature_id), PRIMARY KEY(group_id, feature_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_group_text (group_id INT NOT NULL, lang VARCHAR(2) NOT NULL, title VARCHAR(255) NOT NULL, INDEX group_lang (group_id, lang), PRIMARY KEY(group_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_in_group (id INT AUTO_INCREMENT NOT NULL, group_id INT DEFAULT NULL, virtual_category_id INT DEFAULT NULL, position INT UNSIGNED DEFAULT 0 NOT NULL, INDEX IDX_879CB405FE54D947 (group_id), INDEX IDX_879CB4051C639273 (virtual_category_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_related (id INT AUTO_INCREMENT NOT NULL, virtual_category_id INT DEFAULT NULL, target_id INT UNSIGNED NOT NULL, target_key VARCHAR(255) NOT NULL, position INT NOT NULL, INDEX category (virtual_category_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_advanced_feature__virtual_category_text (locale VARCHAR(255) NOT NULL, id INT NOT NULL, url VARCHAR(255) NOT NULL, page_title VARCHAR(255) DEFAULT NULL, filtering_title VARCHAR(255) DEFAULT NULL, page_description LONGTEXT DEFAULT NULL, h1 VARCHAR(255) DEFAULT NULL, menu_title VARCHAR(255) DEFAULT NULL, description LONGTEXT DEFAULT NULL, long_description LONGTEXT DEFAULT NULL, INDEX IDX_5B049818BF396750 (id), INDEX eafvct_url_locale (url, locale), PRIMARY KEY(id, locale)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_categories ADD CONSTRAINT FK_707AA881C639273 FOREIGN KEY (virtual_category_id) REFERENCES eshop_advanced_feature__virtual_category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_categories ADD CONSTRAINT FK_707AA8812469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_manufacturers ADD CONSTRAINT FK_75AF016A1C639273 FOREIGN KEY (virtual_category_id) REFERENCES eshop_advanced_feature__virtual_category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_manufacturers ADD CONSTRAINT FK_75AF016AA23B42D FOREIGN KEY (manufacturer_id) REFERENCES eshop_catalog__manufacturer (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_features ADD CONSTRAINT FK_1F6932AD1C639273 FOREIGN KEY (virtual_category_id) REFERENCES eshop_advanced_feature__virtual_category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_features ADD CONSTRAINT FK_1F6932AD60E4B879 FOREIGN KEY (feature_id) REFERENCES eshop_catalog__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_group_filter ADD CONSTRAINT FK_5B80E786FE54D947 FOREIGN KEY (group_id) REFERENCES eshop_advanced_feature__virtual_category_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_group_filter ADD CONSTRAINT FK_5B80E78660E4B879 FOREIGN KEY (feature_id) REFERENCES eshop_catalog__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_group_text ADD CONSTRAINT FK_2F251057FE54D947 FOREIGN KEY (group_id) REFERENCES eshop_advanced_feature__virtual_category_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_in_group ADD CONSTRAINT FK_879CB405FE54D947 FOREIGN KEY (group_id) REFERENCES eshop_advanced_feature__virtual_category_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_in_group ADD CONSTRAINT FK_879CB4051C639273 FOREIGN KEY (virtual_category_id) REFERENCES eshop_advanced_feature__virtual_category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_related ADD CONSTRAINT FK_C35BB6701C639273 FOREIGN KEY (virtual_category_id) REFERENCES eshop_advanced_feature__virtual_category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_text ADD CONSTRAINT FK_5B049818BF396750 FOREIGN KEY (id) REFERENCES eshop_advanced_feature__virtual_category (id) ON DELETE CASCADE');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_categories DROP FOREIGN KEY FK_707AA881C639273');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_manufacturers DROP FOREIGN KEY FK_75AF016A1C639273');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_features DROP FOREIGN KEY FK_1F6932AD1C639273');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_in_group DROP FOREIGN KEY FK_879CB4051C639273');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_related DROP FOREIGN KEY FK_C35BB6701C639273');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_text DROP FOREIGN KEY FK_5B049818BF396750');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_group_filter DROP FOREIGN KEY FK_5B80E786FE54D947');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_group_text DROP FOREIGN KEY FK_2F251057FE54D947');
		$this->addSql('ALTER TABLE eshop_advanced_feature__virtual_category_in_group DROP FOREIGN KEY FK_879CB405FE54D947');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_categories');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_manufacturers');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_features');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_group');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_group_filter');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_group_text');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_in_group');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_related');
		$this->addSql('DROP TABLE eshop_advanced_feature__virtual_category_text');
	}
}
