<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_advanced_feature__virtual_category_group')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class VirtualCategoryGroup
{
	use TId;
	use TTranslateListener;

	/** @var Collection<string, VirtualCategoryGroupText> */
	#[ORM\OneToMany(mappedBy: 'group', targetEntity: VirtualCategoryGroupText::class, indexBy: 'lang')]
	public Collection $texts;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $icon = null;

	/** @var Collection<VirtualCategoryInGroup> */
	#[ORM\OneToMany(mappedBy: 'group', targetEntity: VirtualCategoryInGroup::class)]
	#[ORM\OrderBy(['position' => 'ASC'])]
	public Collection $virtualCategoriesInGroup;

	/** @var Collection<VirtualCategoryGroupFilter> */
	#[ORM\OneToMany(mappedBy: 'group', targetEntity: VirtualCategoryGroupFilter::class, indexBy: 'feature_id')]
	#[ORM\OrderBy(['position' => 'ASC'])]
	public Collection $filters;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $templatePageGroup = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $templatePageItem = null;

	public function __construct()
	{
		$this->texts                    = new ArrayCollection;
		$this->virtualCategoriesInGroup = new ArrayCollection;
		$this->filters                  = new ArrayCollection;
	}

	public function getText(?string $lang = null): ?VirtualCategoryGroupText { return $this->texts[$lang ?: $this->locale] ?? null; }
}
