<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_advanced_feature__virtual_category_group_text')]
#[ORM\Index(columns: ['group_id', 'lang'], name: 'group_lang')]
#[ORM\Entity]
class VirtualCategoryGroupText
{
	#[ORM\JoinColumn(name: 'group_id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: VirtualCategoryGroup::class, inversedBy: 'texts')]
	protected VirtualCategoryGroup $group;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $title;

	#[ORM\Column(name: 'description', type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	/**
	 * @var array
	 */
	#[ORM\Column(type: 'array')]
	protected $texts = [];

	public function __construct(
		VirtualCategoryGroup $group,
		string               $lang,
		string               $title
	)
	{
		$this->group = $group;
		$this->lang  = $lang;
		$this->title = $title;
		$this->texts = [];
	}

	public function getGroup(): VirtualCategoryGroup { return $this->group; }
}
