<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\Repository\SortableRepository;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('eshop_advanced_feature__virtual_category_related')]
#[ORM\Index(columns: ['virtual_category_id'], name: 'category')]
#[ORM\Entity(repositoryClass: SortableRepository::class)]
class VirtualCategoryRelated
{
	use TId;

	/** @Gedmo\SortableGroup */
	#[ORM\JoinColumn(name: 'virtual_category_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: VirtualCategory::class, inversedBy: 'related')]
	public VirtualCategory $virtualCategory;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true])]
	public int $targetId;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $targetKey = 'category';

	/** @Gedmo\SortablePosition */
	#[ORM\Column(type: Types::INTEGER, nullable: false)]
	protected int $position = 0;

	public function __construct(
		VirtualCategory $virtualCategory,
		int             $targetId
	)
	{
		$this->virtualCategory = $virtualCategory;
		$this->targetId        = $targetId;
		$this->setPosition(-1);
	}

	public function setPosition(int $pos): void { $this->position = $pos; }
}
