<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Helpers\Strings;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Json;

#[ORM\Table('eshop_advanced_feature__virtual_category_text')]
#[ORM\Index(columns: ['url', 'locale'], name: 'eafvct_url_locale')]
#[ORM\Entity]
class VirtualCategoryText implements ITemplate
{
	#[ORM\JoinColumn(name: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: VirtualCategory::class, inversedBy: 'texts')]
	protected VirtualCategory $virtualCategory;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	protected string $locale;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	protected string $url;

	/**
	 * SEO titulek
	 */
	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $pageTitle = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $filteringTitle = null;

	/**
	 * SEO description
	 */
	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $pageDescription = null;

	/**
	 * Nadpis H1
	 */
	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $h1 = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $menuTitle = null;

	/**
	 * Kategorie kraty popis
	 */
	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	/**
	 * Kategorie dlouhy popis
	 */
	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $longDescription = null;

	/**
	 * @var array
	 */
	#[ORM\Column(type: 'array', nullable: true)]
	protected $texts = [];

	public function __construct(
		VirtualCategory $virtualCategory,
		string          $locale,
		string          $url
	)
	{
		$this->virtualCategory = $virtualCategory;
		$this->locale          = $locale;
		$this->texts           = [];
		$this->setUrl($url);
	}

	public function getVirtualCategory(): VirtualCategory { return $this->virtualCategory; }

	public function setUrl(string $url): void
	{
		if (!Strings::startsWith($url, '/')) {
			$url = '/' . $url;
		}

		$this->url = Strings::webalize($url, '/');
	}

	public function getUrl(): string { return $this->url; }

	public function getTexts(): array { return $this->texts ?: []; }

	/**
	 * @param string $key
	 *
	 * @return string
	 */
	public function getText($key) { return $this->texts[$key] ?? ''; }

	public function setTexts($texts)
	{
		$this->texts = is_array($texts) ? $texts : Json::decode($texts, Json::FORCE_ARRAY);
	}
}
