<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model;

use Core\Model\Lang\Langs;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class GroupsCache
{
	public const cacheNamespace = 'eshopVirtualCategoryGroup';

	protected Cache $cache;

	public function __construct(
		Storage         $storage,
		protected Langs $langs
	)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	public function getCache(): Cache { return $this->cache; }

	public function removeGroup(int $id, string $lang): void
	{
		$this->getCache()->remove(self::getKey($id, $lang));
	}

	public function removeBase(): void
	{
		foreach ($this->langs->getLangs(false) as $lang) {
			$this->getCache()->remove('groupsBase/' . $lang->getTag());
			$this->getCache()->remove('groupsBaseByVc/' . $lang->getTag());
		}
	}

	public static function getKey(int $id, string $lang): string { return $id . '/' . $lang; }
}
