<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\SitemapGeneratorEvent;
use Navigations\Model\NavigationConfig;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Thepixeldeveloper\Sitemap\Extensions\Link;
use Thepixeldeveloper\Sitemap\Url;

class SitemapSubscriber implements EventSubscriberInterface
{
	protected array $forRemove = [];

	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'sitemap.generate' => ['sitemapGenerate'],
		];
	}

	public function sitemapGenerate(SitemapGeneratorEvent $event): void
	{
		if ($event->group !== 'default') {
			return;
		}

		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT vc.id, GROUP_CONCAT(DISTINCT CONCAT(vct.locale, '|', vct.url) SEPARATOR '||') as urls 
    				FROM eshop_advanced_feature__virtual_category vc
    				INNER JOIN eshop_advanced_feature__virtual_category_text vct ON vc.id = vct.id
					WHERE vc.site_ident = :site AND vc.add_to_sitemap = 1
					GROUP BY vc.id
    				", [
			'site' => $event->site->getIdent(),
		]) as $row) {
			$baseUrl   = null;
			$otherUrls = [];

			foreach (explode('||', (string) $row['urls']) as $tmp) {
				$tmp = explode('|', $tmp);

				if ($tmp[0] === $event->lang) {
					$baseUrl = $tmp[1];
				} else {
					$otherUrls[$tmp[0]] = $tmp[1];
				}
			}

			if (!$baseUrl) {
				continue;
			}

			if (NavigationConfig::load('useEndSlash')) {
				$baseUrl = rtrim($baseUrl, '/') . '/';
			}

			$url = new Url($event->domain . ltrim($baseUrl, '/'));

			foreach ($otherUrls as $lang => $otherUrl) {
				$langDomain = $event->site->getDomains()[$lang] ?? null;
				if (!$langDomain || !$langDomain->isActive) {
					continue;
				}

				$domain  = $langDomain->isDefault ? $langDomain->getDomain() : $langDomain->getDomain() . '/' . $lang;
				$linkExt = new Link($lang, 'https://' . $domain . '/' . ltrim($otherUrl, '/'));
				$url->addExtension($linkExt);
			}

			$event->addToResult($url);
		}
	}
}
