<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\Event\SetFormDataEvent;
use Doctrine\ORM\EntityManager;
use EshopCatalog\AdminModule\Components\Features\FeatureValueForm;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\FeatureValue;

class FeatureValueFormSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $entityManager;

	/** @var CacheService */
	protected $cacheService;

	public function __construct(EntityManager $entityManager, CacheService $cacheService)
	{
		$this->entityManager = $entityManager;
		$this->cacheService  = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FeatureValueForm::class . '::createForm'      => ['createForm', 100],
			FeatureValueForm::class . '::formSuccess'     => ['formSuccess', 100],
			FeatureValueForm::class . '::setFeatureValue' => ['setFeatureValue', 100],
		];
	}

	public function createForm(CreateFormEvent $event): void
	{
		$form = $event->form;

		$form->addGroup('eshopAdvancedFeature.featureValueForm.title');
		$form->addText('rodM', 'eshopAdvancedFeature.featureValueForm.rodM')
			->setIsMultilanguage()
			->setMaxLength(255);
		$form->addText('rodZ', 'eshopAdvancedFeature.featureValueForm.rodZ')
			->setIsMultilanguage()
			->setMaxLength(255);
		$form->addText('rodS', 'eshopAdvancedFeature.featureValueForm.rodS')
			->setIsMultilanguage()
			->setMaxLength(255);
	}

	public function formSuccess(FormSuccessEvent $event): void
	{
		/** @var FeatureValue $featureValue */
		$featureValue = $event->custom['entity'];
		$values       = $event->values;

		$langValues = $event->form->convertMultilangValuesToArray();
		$texts      = $featureValue->getFeatureValueTexts()->toArray();

		foreach ($langValues as $l => $v) {
			if (!isset($texts[$l]))
				continue;

			$texts[$l]->rodM = $v['rodM'];
			$texts[$l]->rodZ = $v['rodZ'];
			$texts[$l]->rodS = $v['rodS'];

			$this->entityManager->persist($texts[$l]);
		}

		$this->entityManager->flush();
	}

	public function setFeatureValue(SetFormDataEvent $event): void
	{
		/** @var FeatureValue $featureValue */
		$featureValue = $event->entity;
		$fvTexts      = $featureValue->getFeatureValueTexts()->toArray();

		$texts = [];
		foreach ($fvTexts as $row) {
			foreach (['rodM', 'rodZ', 'rodS'] as $rod) {
				$texts[$rod][$row->getLang()] = $row->$rod;
			}
		}

		if ($texts)
			$event->form->setDefaults($texts);
	}
}
