<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Doctrine\ORM\EntityManager;
use EshopAdvancedFeature\Model\PrefixSuffixGenerator;
use EshopCatalog\FrontModule\Model\Event\CategoryHeadEvent;
use Nette\Localization\ITranslator;

class DefaultSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $entityManager;

	/** @var ITranslator */
	protected $translator;

	/** @var PrefixSuffixGenerator */
	protected $prefixSuffixGenerator;

	public function __construct(EntityManager $entityManager, ITranslator $translator, PrefixSuffixGenerator $prefixSuffixGenerator)
	{
		$this->entityManager         = $entityManager;
		$this->translator            = $translator;
		$this->prefixSuffixGenerator = $prefixSuffixGenerator;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopCatalog.default.actionCategory.head' => ['actionCategoryHead', 100],
		];
	}

	public function actionCategoryHead(CategoryHeadEvent $event): void
	{
		$filters = $event->activeFilters;

		$data = $this->prefixSuffixGenerator->generate(
			$filters['features'] ?? [],
			$filters['manu'] ?? [],
			$filters['priceRange'] ?? [],
			$event->category->id,
		);

		$event->title        = $this->prefixSuffixGenerator->addPrefixSuffix($event->title, $data['prefix'], $data['suffix']);
		$event->categoryName = $this->prefixSuffixGenerator->addPrefixSuffix($event->categoryName, $data['prefix'], $data['suffix']);
	}
}
