<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_advanced_feature__feature_navigation")
 * @ORM\Entity
 */
class FeatureNavigation
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="url", type="string", nullable=false)
	 */
	public $url;

	/**
	 * @var int
	 * @ORM\Column(name="navigation_id", type="integer", nullable=false)
	 */
	public $navigationId;

	/**
	 * @var bool
	 * @ORM\Column(name="dynamic_params", type="boolean", nullable=false, options={"default": 0})
	 */
	public $dynamicParams;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=false)
	 */
	public $params;

	/**
	 * @var string
	 * @ORM\Column(name="page_title", type="string", nullable=true)
	 */
	public $pageTitle;

	/**
	 * @var string
	 * @ORM\Column(name="page_description", type="text", nullable=true)
	 */
	public $pageDescription;

	/**
	 * @var string
	 * @ORM\Column(name="h1", type="string", nullable=true)
	 */
	public $h1;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public $description;

	public function __construct(string $url, int $navigationId, array $params)
	{
		$this->url           = $url;
		$this->navigationId  = $navigationId;
		$this->params        = $params;
		$this->dynamicParams = false;
	}
}
