<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\Query;
use EshopAdvancedFeature\Model\Entities\FeatureNavigation;

class FeatureNavigations extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = FeatureNavigation::class;

	public function forNavigationByUrl(string $url): ?array
	{
		return $this->getEr()->createQueryBuilder('fn')
			->select('fn.params, fn.dynamicParams, fn.navigationId')
			->where('fn.url = :url')->setParameter('url', $url)
			->setMaxResults(1)
			->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);
	}
}
