<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model;

use EshopCatalog\Model\Entities\CategoryTexts;
use EshopCatalog\Model\Entities\Feature;
use EshopCatalog\Model\Entities\FeatureValue;
use Kdyby\Doctrine\EntityManager;

class PatternDetermination
{
	/** @var EntityManager */
	protected $em;

	/** @var array */
	protected $cSearchInDb;

	public function __construct(EntityManager $em)
	{
		$this->em = $em;
	}

	protected function loadFeatures()
	{
		$features = [];

		foreach ($this->em->getRepository(Feature::class)->createQueryBuilder('f')->select('f.id, ft.name')
			         ->join('f.featureTexts', 'ft', 'WITH', 'ft.lang = :lang')->setParameter('lang', 'cs')
			         ->getQuery()->getArrayResult() as $row)
			$features[$row['id']] = [
				'name'   => $row['name'],
				'values' => [],
			];

		foreach ($this->em->getRepository(FeatureValue::class)->createQueryBuilder('fv')->select('fv.id, fvt.name, IDENTITY(fv.feature) as feature')
			         ->join('fv.featureValueTexts', 'fvt', 'WITH', 'fvt.lang = :lang')->setParameter('lang', 'cs')
			         ->getQuery()->getArrayResult() as $row)
			$features[$row['feature']]['values'][$row['id']] = $row['name'];

		return $features;
	}

	protected function loadCategories()
	{
		$categories = [];

		foreach ($this->em->getRepository(CategoryTexts::class)->createQueryBuilder('ct')->select('ct.name, IDENTITY(ct.id) as id')
			         ->andWhere('ct.lang = :lang')->setParameter('lang', 'cs')
			         ->getQuery()->getArrayResult() as $row)
			$categories[$row['id']] = [
				'name' => $row['name'],
			];

		return $categories;
	}

	public function discern()
	{
		$categories = $this->loadCategories();
		foreach ($categories as $id => $values) {
			$categories[$id]['rod'] = $this->searchInDB($values['name']);

			if (!$categories[$id]['rod'])
				$categories[$id]['rod'] = $this->searchByPattern($values['name']);
		}

		dump($categories);

		//		$features = $this->loadFeatures();
		//
		//		$colors = $features[10087];
		//
		//		foreach ($colors['values'] as $id => $value) {
		//
		//		}
	}

	protected function searchInDB(string $value): ?string
	{
		if (is_null($this->cSearchInDb)) {
			$stmt = $this->em->getConnection()->prepare("SELECT * FROM rody_pdst_jmen");
			$stmt->execute();
			$this->cSearchInDb = [];

			foreach ($stmt->fetchAll() as $row) {
				$row['name']         = strtolower($row['name']);
				$this->cSearchInDb[] = $row;
			}
		}

		$value = strtolower($value);
		foreach ($this->cSearchInDb as $row) {
			if (strpos($value, $row['name']) === false)
				continue;

			return $row['rod'];
		}

		return null;
	}

	protected function searchByPattern(string $value): ?string
	{
		$end3 = substr($value, -3);
		$end2 = substr($value, -2);

		if (in_array($end3, ['mám']) || in_array($end2, ['ty', 'ky', 'my', 'hy']))
			return 'z';
		if (in_array($end2, ['ví', 'ní']))
			return 's';
		if(in_array($end2, ['ry']))
			return 'm';

		return null;
	}
}
