<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Doctrine\ORM\EntityManager;
use EshopAdvancedFeature\Model\Entities\FeatureNavigation;
use EshopAdvancedFeature\Model\FeatureNavigations;
use EshopAdvancedFeature\Model\PrefixSuffixGenerator;
use Navigations\Model\Event\RouteInEvent;
use EshopCatalog\Model\Event\RouteInFindAliasEvent;
use Navigations\Model\Event\RouteOutEvent;
use EshopCatalog\Model\Navigation\BaseNavigation;
use EshopCatalog\Model\NavigationFilter;
use Navigations\Model\Event\RouteUpdateCacheDep;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Utils\Strings;

class NavigationSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $entityManager;

	/** @var PrefixSuffixGenerator */
	protected $prefixSuffixGenerator;

	/** @var NavigationFilter */
	protected $navigationFilter;

	/** @var FeatureNavigations */
	protected $featureNavigations;

	/** @var Navigations */
	protected $navigations;

	/** @var array */
	protected $cUrls;

	protected static $outFilter = [];

	public function __construct(EntityManager $entityManager, PrefixSuffixGenerator $prefixSuffixGenerator, NavigationFilter $navigationFilter,
	                            FeatureNavigations $featureNavigations, Navigations $navigations)
	{
		$this->entityManager         = $entityManager;
		$this->prefixSuffixGenerator = $prefixSuffixGenerator;
		$this->navigationFilter      = $navigationFilter;
		$this->featureNavigations    = $featureNavigations;
		$this->navigations           = $navigations;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			Navigations::class . '::routeInNotFound'        => ['routeInNotFound', 110],
			BaseNavigation::class . '::routeIn'             => ['routeIn', 110],
			BaseNavigation::class . '::routeInFindAlias'    => ['routeInFindAlias', 110],
			BaseNavigation::class . '::routeOut'            => ['routeOut', 110],
			BaseNavigation::class . '::routeUpdateCacheDep' => ['routeUpdateCacheDep', 110],
		];
	}

	public function routeUpdateCacheDep(RouteUpdateCacheDep $event)
	{
		if (!empty(self::$outFilter['features'])) {
			foreach (self::$outFilter['features'] as $v)
				$event->cache[Cache::TAGS][] = 'categoriesFilter_ff_' . $v;

			self::$outFilter = [];
		}
	}

	public function routeInNotFound(RouteInEvent $event)
	{
		$entity = $this->featureNavigations->forNavigationByUrl($event->urlParams['path']);

		if ($entity) {
			$navigation = $this->navigations->getNavigation((int) $entity['navigationId']);
			if ($navigation) {
				$event->return                     = $this->returnEntityParams($event->urlParams, $entity['params'], $entity['dynamicParams']);
				$event->return['activeNavigation'] = $navigation;
				$event->stopPropagation();
			}
		}
	}

	public function routeIn(RouteInEvent $event): void
	{
	}

	public function routeInFindAlias(RouteInFindAliasEvent $event)
	{
		$entity = $this->featureNavigations->forNavigationByUrl($event->alias);

		if ($entity) {
			$event->return = $this->returnEntityParams($event->urlParams, $entity['params'], $entity['dynamicParams']);
		}
	}

	public function routeOut(RouteOutEvent $event): void
	{
		if ($event->urlParams['action'] === 'search')
			return;

		$oUrlParams = $event->urlParams;
		$urlParams  = &$event->urlParams;
		$url        = &$event->url;

		$features      = [];
		$manufacturers = [];
		$priceRange    = [];

		if (isset($urlParams['productsFilter-filter'])) {
			$filter = $urlParams['productsFilter-filter'];

			// Features
			if (isset($filter['ff'])) {
				foreach ($filter['ff'] as $k => $v)
					$features[$k] = explode('|', $v);
			}

			// Manufacturer
			if (isset($filter['fm'][0])) {
				$manufacturers = explode('|', $filter['fm'][0]);
			}
		}

		if (isset($urlParams['productsFilter-t'], $urlParams['productsFilter-k'])) {
			$newFilterType  = $urlParams['productsFilter-t'];
			$newFilterKey   = $urlParams['productsFilter-k'];
			$newFilterValue = $urlParams['productsFilter-v'];
			$removeValue    = false;

			if ($newFilterType === 'feature') {
				//Feature
				if (!empty($features[$newFilterKey])) {
					foreach ($features[$newFilterKey] as $k => $v) {
						if ((int) $v == $newFilterValue) {
							unset($features[$newFilterKey][$k]);
							$removeValue = true;
							break;
						}
					}

					if (!$removeValue)
						$features[$newFilterKey][] = $newFilterValue;
				} else {
					$features[$newFilterKey][] = $newFilterValue;
				}

				if ($newFilterValue === null)
					unset($features[$newFilterKey]);
			} else if ($newFilterType === 'manu') {
				// Manufacturer
				foreach ($manufacturers as $k => $v) {
					if ($v == $newFilterValue) {
						unset($manufacturers[$k]);
						$removeValue = true;
						break;
					}
				}

				if (!$removeValue)
					$manufacturers[] = $newFilterValue;

				if ($newFilterValue === null)
					$manufacturers = [];
			}
		}

		foreach ($features as $k => $v)
			$features[$k] = array_values($v);

		$categoryId = $urlParams['action'] === 'category' ? (int) $urlParams['id'] : null;
		$data       = $this->prefixSuffixGenerator->generate($features, $manufacturers, $priceRange, $categoryId);
		if ($data['prefix'] !== '' || $data['suffix'] !== '') {
			if ($data['isMultiple'] === false) {
				unset($urlParams['productsFilter-filter']);
				unset($urlParams['productsFilter-t']);
				unset($urlParams['productsFilter-k']);
				unset($urlParams['productsFilter-v']);
				if ($data['prefix'] != " " && $data['suffix'] != " " && $urlParams['do'] === 'productsFilter-set')
					unset($urlParams['do']);
				$event->disableDefaultFilter = true;
			}
			$tmp      = explode('/', $url);
			$lastPart = array_pop($tmp);
			$lastPart = Strings::webalize($this->prefixSuffixGenerator->addPrefixSuffix($lastPart, $data['prefix'], $data['suffix']));
			$tmp[]    = $lastPart;

			$url        = implode('/', $tmp);
			$event->url = $url;

			self::$outFilter['features'] = $data['usedFeatures'];

			if (!in_array($lastPart, $this->getAllUrls())) {
				$entity = new FeatureNavigation($lastPart, (int) $event->navigation->getId(), $this->navigationFilter->processRouterOut($oUrlParams));
				if ($data['isMultiple'])
					$entity->dynamicParams = true;
				$this->entityManager->persist($entity);
				$this->entityManager->flush();
				$this->cUrls[$entity->getId()] = $lastPart;
			}
		}

		foreach ($features as $k => $v) {
			if ($urlParams['productsFilter-k'] == $k)
				continue;

			if (empty($data['usedFeatures']) || !in_array($k, $data['usedFeatures']) || $data['isMultiple']) {
				$urlParams = $oUrlParams;
				break;
			}
		}
	}

	protected function returnEntityParams(array $urlParams, array $params, bool $dynamicParams): array
	{
		if ($dynamicParams === true && isset($urlParams['productsFilter-filter']))
			$params['productsFilter-filter'] = $urlParams['productsFilter-filter'];

		return $params;
	}

	protected function getAllUrls(): array
	{
		if ($this->cUrls === null) {
			$this->cUrls = [];
			foreach ($this->entityManager->getRepository(FeatureNavigation::class)->createQueryBuilder('fn')
				         ->select('fn.url', 'fn.id')
				         ->getQuery()->getScalarResult() as $row)
				$this->cUrls[$row['id']] = $row['url'];
		}

		return $this->cUrls;
	}
}
