<?php declare(strict_types = 1);

namespace EshopBulkOrder\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class BulkOrder extends BaseNavigation implements INavigationItem
{
	protected $title = 'bulkOrder';

	protected $presenter = 'EshopBulkOrder:Front:Default';
	protected $action    = 'bulkOrder';

	public function __construct()
	{
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer(): BaseContainer
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	public function updateCacheDep(array &$cache, $urlParams)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return array|mixed
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		$parts    = explode('/', $urlParams['path']);
		$category = null;

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '/' : '/' . $navigation->alias;
	}
}
