import {FormatMoney} from 'core/js/utils/formatMoney';

const bulkOrderProductsList = document.getElementById('bulk-order-products-list');

if (bulkOrderProductsList) {
	class BulkOrderForm {
		constructor(el) {
			this.el = el;
			this.rows = [];
			this.elTotalPrice = el.querySelector('.totalPriceWrap');
			this.elTotalPriceWithoutVat = el.querySelector('.totalPriceWithoutVatWrap');
			this.totalPrice = 0;
			this.totalPriceWithoutVat = 0;

			bulkOrderProductsList.querySelectorAll('.cd__item').forEach(item => {
				const row = new BulkOrderRow(item);
				row.afterUpdatePrice.push((row) => {
					this.updateTotalPrice();
				});

				this.rows.push(row);
			});
		}

		updateTotalPrice() {
			this.totalPrice = 0;
			this.totalPriceWithoutVat = 0;

			this.rows.forEach(row => {
				if (isNaN(row.getTotalPrice()))
					return true;
				this.totalPrice += row.getTotalPrice();
				this.totalPriceWithoutVat += row.getTotalPriceWithoutVat();
			});

			this.elTotalPrice.innerHTML = FormatMoney.format(this.totalPrice, 0, '');
			this.elTotalPriceWithoutVat.innerHTML = FormatMoney.format(this.totalPriceWithoutVat);
		}
	}

	class BulkOrderRow {
		constructor(el) {
			this.el = el;
			this.elTotalPrice = el.querySelector('.itemTotalPriceWrap');
			this.elTotalPriceWithoutVat = el.querySelector('.itemTotalPriceWithoutVatWrap');
			this.price = parseFloat(el.dataset.price);
			this.priceWithoutVat = parseFloat(el.dataset.priceWithoutVat);
			this.afterUpdatePrice = [];

			el.querySelectorAll('.cart-add__quantity-input input').forEach(input => {
				this.input = input;
				input.addEventListener('change', e => {
					this.updatePrice();
				});

				this.isInit = true;
				this.updatePrice();
				this.isInit = false;
			});
		}

		getTotalPrice() {
			return parseFloat(this.totalPrice);
		}

		getTotalPriceWithoutVat() {
			return parseFloat(this.totalPriceWithoutVat);
		}

		updatePrice() {
			if (!this.input) {
				this.totalPrice = 0;
				this.totalPriceWithoutVat = 0;

				return;
			}
			this.totalPrice = this.price * this.input.value;
			this.totalPriceWithoutVat = (this.priceWithoutVat * this.input.value);

			this.elTotalPrice.innerHTML = FormatMoney.format(this.totalPrice, 0, '');
			this.elTotalPriceWithoutVat.innerHTML = FormatMoney.format(this.totalPriceWithoutVat);

			if (this.isInit === false)
				this.afterUpdatePrice.forEach(c => {
					c(this);
				});
		}
	}

	const bulkOrderForm = new BulkOrderForm(bulkOrderProductsList);
}
