<?php declare(strict_types = 1);

namespace EshopBulkOrder\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class BulkOrder extends BaseNavigation implements INavigationItem
{
	/** @var string */
	protected $title = 'bulkOrder';

	/** @var string */
	protected $presenter = 'EshopBulkOrder:Front:Default';

	/** @var string */
	protected $action = 'bulkOrder';

	public function __construct()
	{
	}

	public function getFormContainer(BaseForm $baseForm): BaseContainer
	{
		return new BaseContainer;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{

	}

	public function updateCacheDep(array &$cache, $urlParams): void
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	/**
	 * @param string $presenter
	 * @param string $action
	 */
	public function presenterActionCheck($presenter, $action): bool
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @param Navigation|DaoNavigationItem $navigation
	 * @param array             $urlParams
	 */
	public function routerIn($navigation, $urlParams = []): array
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	/**
	 * @param array $urlParams
	 */
	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '/' : '/' . $navigation->alias;
	}

}